/*
 * Decompiled with CFR 0.152.
 */
package com.tino1b2be.cmdprograms;

import com.tino1b2be.audio.AudioFileException;
import com.tino1b2be.cmdprograms.TestResult;
import com.tino1b2be.dtmfdecoder.DTMFUtil;
import java.io.File;
import java.util.ArrayList;

public class TestThread
extends Thread {
    private TestResult[] results;
    private ArrayList<File> files;
    private int start;
    public int tries = 0;
    public int hits = 0;
    public double hitrate;
    private int pass = 0;
    private int total = 0;
    public double passRate;
    public String parent;

    public TestThread(ArrayList<File> files, TestResult[] results, int start) {
        this.files = files;
        this.results = results;
        this.start = start;
        this.parent = files.get(0).getParentFile().getName();
    }

    @Override
    public void run() {
        try {
            this.sequential();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.hitrate = 1.0 * (double)this.hits * 100.0 / ((double)this.tries * 1.0);
    }

    private void sequential() throws AudioFileException, Exception {
        int i = this.start;
        for (File file : this.files) {
            DTMFUtil dtmf = new DTMFUtil(file);
            dtmf.decode();
            String decoded = dtmf.getDecoded()[0];
            this.results[i] = new TestResult(file, decoded);
            this.tries += this.results[i].tries;
            this.hits += this.results[i].hits;
            ++this.total;
            if (!this.results[i++].isSuccess()) continue;
            ++this.pass;
        }
    }

    @Override
    public String toString() {
        this.passRate = 100.0 * (double)this.pass / ((double)this.total * 1.0);
        return this.parent.substring(0, this.parent.length() - 2) + "," + this.passRate;
    }
}

